/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.analyze.ReloadAnalyzersResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SynonymUpdateResponse
extends ActionResponse
implements StatusToXContentObject {
    private final SynonymsManagementAPIService.UpdateSynonymsResultStatus updateStatus;
    private final ReloadAnalyzersResponse reloadAnalyzersResponse;

    public SynonymUpdateResponse(StreamInput in) throws IOException {
        super(in);
        this.updateStatus = in.readEnum(SynonymsManagementAPIService.UpdateSynonymsResultStatus.class);
        this.reloadAnalyzersResponse = new ReloadAnalyzersResponse(in);
    }

    public SynonymUpdateResponse(SynonymsManagementAPIService.SynonymsReloadResult synonymsReloadResult) {
        SynonymsManagementAPIService.UpdateSynonymsResultStatus updateStatus = synonymsReloadResult.synonymsOperationResult();
        Objects.requireNonNull(updateStatus, "Update status must not be null");
        ReloadAnalyzersResponse reloadResponse = synonymsReloadResult.reloadAnalyzersResponse();
        Objects.requireNonNull(reloadResponse, "Reload analyzers response must not be null");
        this.updateStatus = updateStatus;
        this.reloadAnalyzersResponse = reloadResponse;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("result", this.updateStatus.name().toLowerCase(Locale.ENGLISH));
        builder.field("reload_analyzers_details");
        this.reloadAnalyzersResponse.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.updateStatus);
        this.reloadAnalyzersResponse.writeTo(out);
    }

    @Override
    public RestStatus status() {
        return switch (this.updateStatus) {
            case SynonymsManagementAPIService.UpdateSynonymsResultStatus.CREATED -> RestStatus.CREATED;
            default -> RestStatus.OK;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymUpdateResponse response = (SynonymUpdateResponse)o;
        return this.updateStatus == response.updateStatus && Objects.equals(this.reloadAnalyzersResponse, response.reloadAnalyzersResponse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.updateStatus, this.reloadAnalyzersResponse});
    }
}

