/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.reservedstate.ActionWithReservedState;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeAction<Request extends MasterNodeRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response>
implements ActionWithReservedState<Request> {
    private static final Logger logger = LogManager.getLogger(TransportMasterNodeAction.class);
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Writeable.Reader<Response> responseReader;
    protected final Executor executor;

    protected TransportMasterNodeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Response> response, String executor) {
        this(actionName, true, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver, response, executor);
    }

    protected TransportMasterNodeAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Response> response, String executor) {
        super(actionName, canTripCircuitBreaker, transportService, actionFilters, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = threadPool.executor(executor);
        this.responseReader = response;
    }

    protected abstract void masterOperation(Task var1, Request var2, ClusterState var3, ActionListener<Response> var4) throws Exception;

    private void executeMasterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        CancellableTask cancellableTask;
        if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled()) {
            throw new TaskCancelledException("Task was cancelled");
        }
        this.masterOperation(task, request, state, listener);
    }

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    private ClusterBlockException checkBlockIfStateRecovered(Request request, ClusterState state) {
        try {
            return this.checkBlock(request, state);
        }
        catch (IndexNotFoundException e) {
            if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                assert (GatewayService.STATE_NOT_RECOVERED_BLOCK.contains(ClusterBlockLevel.METADATA_READ));
                assert (state.blocks().global(ClusterBlockLevel.METADATA_READ).stream().allMatch(ClusterBlock::retryable));
                return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
            }
            throw e;
        }
    }

    void validateForReservedState(Request request, ClusterState state) {
        Optional<String> handlerName = this.reservedStateHandlerName();
        assert (handlerName.isPresent());
        this.validateForReservedState(state, handlerName.get(), this.modifiedKeys(request), ((TransportRequest)request).toString());
    }

    boolean supportsReservedState() {
        return this.reservedStateHandlerName().isPresent();
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState state = this.clusterService.state();
        if (this.supportsReservedState()) {
            this.validateForReservedState(request, state);
        }
        logger.trace("starting processing request [{}] with cluster state version [{}]", request, (Object)state.version());
        if (task != null) {
            request.setParentTask(this.clusterService.localNode().getId(), task.getId());
        }
        ((TransportMessage)request).incRef();
        new AsyncSingleAction(this, task, request, ActionListener.runBefore(listener, () -> request.decRef())).doStart(state);
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private ClusterStateObserver observer;
        private final long startTime;
        private final Task task;
        final /* synthetic */ TransportMasterNodeAction this$0;

        AsyncSingleAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.startTime = this$0.threadPool.relativeTimeInMillis();
        }

        protected void doStart(ClusterState clusterState) {
            if (this.isTaskCancelled()) {
                this.listener.onFailure(new TaskCancelledException("Task was cancelled"));
                return;
            }
            final long currentStateVersion = clusterState.version();
            try {
                final DiscoveryNodes nodes = clusterState.nodes();
                if (nodes.isLocalNodeElectedMaster() || this.this$0.localExecute(this.request)) {
                    ClusterBlockException blockException = this.this$0.checkBlockIfStateRecovered(this.request, clusterState);
                    if (blockException != null) {
                        if (!blockException.retryable()) {
                            logger.trace("can't execute due to a non-retryable cluster block", (Throwable)blockException);
                            this.listener.onFailure(blockException);
                        } else {
                            logger.debug("can't execute due to a cluster block, retrying", (Throwable)blockException);
                            this.retry(currentStateVersion, blockException, newState -> {
                                try {
                                    ClusterBlockException newException = this.this$0.checkBlockIfStateRecovered(this.request, (ClusterState)newState);
                                    return newException == null || !newException.retryable();
                                }
                                catch (Exception e) {
                                    logger.debug("exception occurred during cluster block checking, accepting state", (Throwable)e);
                                    return true;
                                }
                            });
                        }
                    } else {
                        ActionListener delegate = this.listener.delegateResponse((delegatedListener, t) -> {
                            if (MasterService.isPublishFailureException(t)) {
                                logger.debug(() -> Strings.format((String)"master could not publish cluster state or stepped down before publishing action [%s], scheduling a retry", (Object[])new Object[]{this.this$0.actionName}), (Throwable)t);
                                this.retryOnNextState(currentStateVersion, (Throwable)t);
                            } else {
                                logger.debug("unexpected exception during publication", (Throwable)t);
                                delegatedListener.onFailure((Exception)t);
                            }
                        });
                        this.this$0.executor.execute(ActionRunnable.wrap(delegate, l -> this.this$0.executeMasterOperation(this.task, this.request, clusterState, l)));
                    }
                } else if (nodes.getMasterNode() == null) {
                    logger.debug("no known master node, scheduling a retry");
                    this.retryOnNextState(currentStateVersion, null);
                } else {
                    final DiscoveryNode masterNode = nodes.getMasterNode();
                    logger.trace("forwarding request [{}] to master [{}]", (Object)this.this$0.actionName, (Object)masterNode);
                    this.this$0.transportService.sendRequest(masterNode, this.this$0.actionName, (TransportRequest)this.request, new ActionListenerResponseHandler<Response>(this.listener, this.this$0.responseReader, this.this$0.executor){

                        @Override
                        public void handleException(TransportException exp) {
                            Throwable cause = exp.unwrapCause();
                            if (cause instanceof ConnectTransportException || exp instanceof RemoteTransportException && cause instanceof NodeClosedException) {
                                logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", (Object)AsyncSingleAction.this.this$0.actionName, (Object)nodes.getMasterNode(), (Object)exp.getDetailedMessage());
                                AsyncSingleAction.this.retryOnNextState(currentStateVersion, cause);
                            } else {
                                logger.trace(() -> Strings.format((String)"failure when forwarding request [%s] to master [%s]", (Object[])new Object[]{AsyncSingleAction.this.this$0.actionName, masterNode}), (Throwable)exp);
                                this.listener.onFailure(exp);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.trace("top-level failure", (Throwable)e);
                this.listener.onFailure(e);
            }
        }

        private void retryOnNextState(long currentStateVersion, Throwable failure) {
            this.retry(currentStateVersion, failure, ClusterStateObserver.NON_NULL_MASTER_PREDICATE);
        }

        private void retry(long currentStateVersion, final Throwable failure, Predicate<ClusterState> statePredicate) {
            if (this.observer == null) {
                long remainingTimeoutMS = ((MasterNodeRequest)this.request).masterNodeTimeout().millis() - (this.this$0.threadPool.relativeTimeInMillis() - this.startTime);
                if (remainingTimeoutMS <= 0L) {
                    logger.debug(() -> "timed out before retrying [" + this.this$0.actionName + "] after failure", failure);
                    this.listener.onFailure(new MasterNotDiscoveredException(failure));
                    return;
                }
                this.observer = new ClusterStateObserver(currentStateVersion, this.this$0.clusterService.getClusterApplierService(), TimeValue.timeValueMillis((long)remainingTimeoutMS), logger, this.this$0.threadPool.getThreadContext());
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    logger.trace("retrying with cluster state version [{}]", (Object)state.version());
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    logger.debug(() -> Strings.format((String)"timed out while retrying [%s] after failure (timeout [%s])", (Object[])new Object[]{AsyncSingleAction.this.this$0.actionName, timeout}), failure);
                    AsyncSingleAction.this.listener.onFailure(new MasterNotDiscoveredException(failure));
                }
            }, clusterState -> this.isTaskCancelled() || statePredicate.test((ClusterState)clusterState));
        }

        private boolean isTaskCancelled() {
            return this.task instanceof CancellableTask && ((CancellableTask)this.task).isCancelled();
        }
    }
}

