/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public final class ThreadedActionListener<Response>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(ThreadedActionListener.class);
    private final Executor executor;
    private final ActionListener<Response> delegate;
    private final boolean forceExecution;

    public ThreadedActionListener(Executor executor, ActionListener<Response> delegate) {
        this(executor, false, delegate);
    }

    public ThreadedActionListener(Executor executor, boolean forceExecution, ActionListener<Response> delegate) {
        this.forceExecution = forceExecution;
        this.executor = executor;
        this.delegate = delegate;
    }

    @Override
    public void onResponse(final Response response) {
        this.executor.execute(new ActionRunnable<Response>(this.delegate){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                this.listener.onResponse(response);
            }

            @Override
            public String toString() {
                return ThreadedActionListener.this + "/onResponse";
            }
        });
    }

    @Override
    public void onFailure(final Exception e) {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                ThreadedActionListener.this.delegate.onFailure(e);
            }

            @Override
            public void onRejection(Exception rejectionException) {
                rejectionException.addSuppressed(e);
                try {
                    ThreadedActionListener.this.delegate.onFailure(rejectionException);
                }
                catch (Exception doubleFailure) {
                    rejectionException.addSuppressed(doubleFailure);
                    this.onFailure(rejectionException);
                }
            }

            @Override
            public void onFailure(Exception e2) {
                logger.error(() -> "failed to execute failure callback on [" + ThreadedActionListener.this + "]", (Throwable)e2);
                assert (false) : e2;
            }

            public String toString() {
                return ThreadedActionListener.this + "/onFailure";
            }
        });
    }

    public String toString() {
        return "ThreadedActionListener[" + this.executor + "/" + this.delegate + "]";
    }
}

