/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportOpenPointInTimeAction
extends HandledTransportAction<OpenPointInTimeRequest, OpenPointInTimeResponse> {
    public static final String OPEN_SHARD_READER_CONTEXT_NAME = "indices:data/read/open_reader_context";
    private final TransportSearchAction transportSearchAction;
    private final SearchTransportService searchTransportService;
    private final TransportService transportService;
    private final SearchService searchService;

    @Inject
    public TransportOpenPointInTimeAction(TransportService transportService, SearchService searchService, ActionFilters actionFilters, TransportSearchAction transportSearchAction, SearchTransportService searchTransportService) {
        super("indices:data/read/open_point_in_time", transportService, actionFilters, OpenPointInTimeRequest::new);
        this.transportService = transportService;
        this.transportSearchAction = transportSearchAction;
        this.searchService = searchService;
        this.searchTransportService = searchTransportService;
        transportService.registerRequestHandler(OPEN_SHARD_READER_CONTEXT_NAME, "same", ShardOpenReaderRequest::new, new ShardOpenReaderRequestHandler());
        TransportActionProxy.registerProxyAction(transportService, OPEN_SHARD_READER_CONTEXT_NAME, false, ShardOpenReaderResponse::new);
    }

    @Override
    protected void doExecute(Task task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(request.indices()).indicesOptions(request.indicesOptions()).preference(request.preference()).routing(request.routing()).allowPartialSearchResults(false);
        searchRequest.setMaxConcurrentShardRequests(request.maxConcurrentShardRequests());
        searchRequest.setCcsMinimizeRoundtrips(false);
        this.transportSearchAction.executeRequest((SearchTask)task, searchRequest, listener.map(r -> {
            assert (r.pointInTimeId() != null) : r;
            return new OpenPointInTimeResponse(r.pointInTimeId());
        }), searchListener -> new OpenPointInTimePhase(request, (ActionListener<SearchResponse>)searchListener));
    }

    private class ShardOpenReaderRequestHandler
    implements TransportRequestHandler<ShardOpenReaderRequest> {
        private ShardOpenReaderRequestHandler() {
        }

        @Override
        public void messageReceived(ShardOpenReaderRequest request, TransportChannel channel, Task task) throws Exception {
            TransportOpenPointInTimeAction.this.searchService.openReaderContext(request.getShardId(), request.keepAlive, new ChannelActionListener(channel).map(ShardOpenReaderResponse::new));
        }
    }

    private final class OpenPointInTimePhase
    implements TransportSearchAction.SearchPhaseProvider {
        private final OpenPointInTimeRequest pitRequest;
        private final ActionListener<SearchResponse> listener;

        OpenPointInTimePhase(OpenPointInTimeRequest pitRequest, ActionListener<SearchResponse> listener) {
            this.pitRequest = pitRequest;
            this.listener = listener;
        }

        @Override
        public SearchPhase newSearchPhase(final SearchTask task, SearchRequest searchRequest, Executor executor, GroupShardsIterator<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, final BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters) {
            assert (searchRequest.getMaxConcurrentShardRequests() == this.pitRequest.maxConcurrentShardRequests()) : searchRequest.getMaxConcurrentShardRequests() + " != " + this.pitRequest.maxConcurrentShardRequests();
            return new AbstractSearchAsyncAction<SearchPhaseResult>(TransportOpenPointInTimeAction.this.actionName, TransportOpenPointInTimeAction.this.logger, TransportOpenPointInTimeAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardIterators.size()), searchRequest.getMaxConcurrentShardRequests(), clusters){

                @Override
                protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchPhaseResult> phaseListener) {
                    ShardOpenReaderRequest shardRequest = new ShardOpenReaderRequest(shardIt.shardId(), shardIt.getOriginalIndices(), OpenPointInTimePhase.this.pitRequest.keepAlive());
                    Transport.Connection connection = (Transport.Connection)connectionLookup.apply(shardIt.getClusterAlias(), shard.getNodeId());
                    TransportOpenPointInTimeAction.this.transportService.sendChildRequest(connection, TransportOpenPointInTimeAction.OPEN_SHARD_READER_CONTEXT_NAME, shardRequest, task, new ActionListenerResponseHandler<ShardOpenReaderResponse>(phaseListener, ShardOpenReaderResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
                }

                @Override
                protected SearchPhase getNextPhase(final SearchPhaseResults<SearchPhaseResult> results, SearchPhaseContext context) {
                    return new SearchPhase(this.getName()){

                        public void run() {
                            AtomicArray<SearchPhaseResult> atomicArray = results.getAtomicArray();
                            this.sendSearchResponse(InternalSearchResponse.EMPTY_WITH_TOTAL_HITS, atomicArray);
                        }
                    };
                }

                @Override
                boolean buildPointInTimeFromSearchResults() {
                    return true;
                }
            };
        }
    }

    private static final class ShardOpenReaderResponse
    extends SearchPhaseResult {
        ShardOpenReaderResponse(ShardSearchContextId contextId) {
            this.contextId = contextId;
        }

        ShardOpenReaderResponse(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.contextId.writeTo(out);
        }
    }

    private static final class ShardOpenReaderRequest
    extends TransportRequest
    implements IndicesRequest {
        final ShardId shardId;
        final OriginalIndices originalIndices;
        final TimeValue keepAlive;

        ShardOpenReaderRequest(ShardId shardId, OriginalIndices originalIndices, TimeValue keepAlive) {
            this.shardId = shardId;
            this.originalIndices = originalIndices;
            this.keepAlive = keepAlive;
        }

        ShardOpenReaderRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
            this.keepAlive = in.readTimeValue();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
            out.writeTimeValue(this.keepAlive);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public String[] indices() {
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }
    }
}

