/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.AliasFilter;

public final class SearchShardsResponse
extends ActionResponse {
    private final Collection<SearchShardsGroup> groups;
    private final Collection<DiscoveryNode> nodes;
    private final Map<String, AliasFilter> aliasFilters;

    public SearchShardsResponse(Collection<SearchShardsGroup> groups, Collection<DiscoveryNode> nodes, Map<String, AliasFilter> aliasFilters) {
        this.groups = groups;
        this.nodes = nodes;
        this.aliasFilters = aliasFilters;
    }

    public SearchShardsResponse(StreamInput in) throws IOException {
        super(in);
        this.groups = in.readList(SearchShardsGroup::new);
        this.nodes = in.readList(DiscoveryNode::new);
        this.aliasFilters = in.readMap(AliasFilter::readFrom);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.groups);
        out.writeCollection(this.nodes);
        out.writeMap(this.aliasFilters, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public Collection<DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public Collection<SearchShardsGroup> getGroups() {
        return this.groups;
    }

    public Map<String, AliasFilter> getAliasFilters() {
        return this.aliasFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsResponse that = (SearchShardsResponse)o;
        return this.groups.equals(that.groups) && this.nodes.equals(that.nodes) && this.aliasFilters.equals(that.aliasFilters);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.nodes, this.aliasFilters);
    }

    static SearchShardsResponse fromLegacyResponse(ClusterSearchShardsResponse oldResp) {
        HashMap<String, Index> indexByNames = new HashMap<String, Index>();
        for (ClusterSearchShardsGroup oldGroup : oldResp.getGroups()) {
            ShardId shardId = oldGroup.getShardId();
            indexByNames.put(shardId.getIndexName(), shardId.getIndex());
        }
        Map<String, AliasFilter> aliasFilters = Maps.newMapWithExpectedSize(oldResp.getIndicesAndFilters().size());
        for (Map.Entry<String, AliasFilter> e : oldResp.getIndicesAndFilters().entrySet()) {
            Index index = (Index)indexByNames.get(e.getKey());
            aliasFilters.put(index.getUUID(), e.getValue());
        }
        List<SearchShardsGroup> groups = Arrays.stream(oldResp.getGroups()).map(SearchShardsGroup::new).toList();
        assert (groups.stream().noneMatch(SearchShardsGroup::preFiltered)) : "legacy responses must not have preFiltered set";
        return new SearchShardsResponse(groups, Arrays.asList(oldResp.getNodes()), aliasFilters);
    }
}

