/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.index.mapper.TimeSeriesParams;

public class IndexFieldCapabilities
implements Writeable {
    private static final StringLiteralDeduplicator typeStringDeduplicator = new StringLiteralDeduplicator();
    private final String name;
    private final String type;
    private final boolean isMetadatafield;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final boolean isDimension;
    private final TimeSeriesParams.MetricType metricType;
    private final Map<String, String> meta;

    IndexFieldCapabilities(String name, String type, boolean isMetadatafield, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType, Map<String, String> meta) {
        this.name = name;
        this.type = type;
        this.isMetadatafield = isMetadatafield;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.isDimension = isDimension;
        this.metricType = metricType;
        this.meta = meta;
    }

    IndexFieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = typeStringDeduplicator.deduplicate(in.readString());
        this.isMetadatafield = in.readBoolean();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
            this.isDimension = in.readBoolean();
            this.metricType = in.readOptionalEnum(TimeSeriesParams.MetricType.class);
        } else {
            this.isDimension = false;
            this.metricType = null;
        }
        this.meta = in.readMap(StreamInput::readString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isMetadatafield);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
            out.writeBoolean(this.isDimension);
            out.writeOptionalEnum(this.metricType);
        }
        out.writeMap(this.meta, StreamOutput::writeString, StreamOutput::writeString);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMetadatafield() {
        return this.isMetadatafield;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public TimeSeriesParams.MetricType getMetricType() {
        return this.metricType;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFieldCapabilities that = (IndexFieldCapabilities)o;
        return this.isMetadatafield == that.isMetadatafield && this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && this.isDimension == that.isDimension && Objects.equals((Object)this.metricType, (Object)that.metricType) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.isMetadatafield, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, this.meta});
    }
}

