/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.FieldUsageShardResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.ChunkedBroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;

public class FieldUsageStatsResponse
extends ChunkedBroadcastResponse {
    private final Map<String, List<FieldUsageShardResponse>> stats;

    FieldUsageStatsResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, List<FieldUsageShardResponse>> stats) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.stats = stats;
    }

    FieldUsageStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap(i -> i.readList(FieldUsageShardResponse::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats, StreamOutput::writeString, StreamOutput::writeList);
    }

    public Map<String, List<FieldUsageShardResponse>> getStats() {
        return this.stats;
    }

    @Override
    protected Iterator<ToXContent> customXContentChunks(ToXContent.Params params) {
        return this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (builder, p) -> {
            builder.startObject((String)entry.getKey());
            builder.startArray("shards");
            for (FieldUsageShardResponse resp : (List)entry.getValue()) {
                resp.toXContent(builder, params);
            }
            builder.endArray();
            return builder.endObject();
        }).iterator();
    }
}

