/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class IndicesShardStoresRequest
extends MasterNodeReadRequest<IndicesShardStoresRequest>
implements IndicesRequest.Replaceable {
    static final int DEFAULT_MAX_CONCURRENT_SHARD_REQUESTS = 100;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpand();
    private EnumSet<ClusterHealthStatus> statuses = EnumSet.of(ClusterHealthStatus.YELLOW, ClusterHealthStatus.RED);
    private int maxConcurrentShardRequests = 100;

    public IndicesShardStoresRequest(String ... indices) {
        this.indices = indices;
    }

    public IndicesShardStoresRequest() {
    }

    public IndicesShardStoresRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int nStatus = in.readVInt();
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (int i = 0; i < nStatus; ++i) {
            this.statuses.add(ClusterHealthStatus.readFrom(in));
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.maxConcurrentShardRequests = in.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0) ? in.readVInt() : Integer.MAX_VALUE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeCollection(this.statuses, (o, v) -> o.writeByte(v.value()));
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0)) {
            out.writeVInt(this.maxConcurrentShardRequests);
        } else if (this.maxConcurrentShardRequests != 100) {
            throw new IllegalArgumentException("support for maxConcurrentShardRequests=[" + this.maxConcurrentShardRequests + "] was added in version [8.8.0], cannot send this request using transport version [" + out.getTransportVersion() + "]");
        }
    }

    public IndicesShardStoresRequest shardStatuses(String ... shardStatuses) {
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (String statusString : shardStatuses) {
            if ("all".equalsIgnoreCase(statusString)) {
                this.statuses = EnumSet.allOf(ClusterHealthStatus.class);
                return this;
            }
            this.statuses.add(ClusterHealthStatus.fromString(statusString));
        }
        return this;
    }

    public IndicesShardStoresRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public IndicesShardStoresRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public EnumSet<ClusterHealthStatus> shardStatuses() {
        return this.statuses;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void maxConcurrentShardRequests(int maxConcurrentShardRequests) {
        this.maxConcurrentShardRequests = maxConcurrentShardRequests;
    }

    public int maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }
}

