/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.xcontent.ToXContent;

public class RecoveryResponse
extends BaseBroadcastResponse
implements ChunkedToXContentObject {
    private final Map<String, List<RecoveryState>> shardRecoveryStates;

    public RecoveryResponse(StreamInput in) throws IOException {
        super(in);
        this.shardRecoveryStates = in.readMapOfLists(RecoveryState::readRecoveryState);
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<RecoveryState>> shardRecoveryStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    public Iterator<ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> b.startObject()), this.shardRecoveryStates.entrySet().stream().filter(entry -> entry != null && !((List)entry.getValue()).isEmpty()).map(entry -> (b, p) -> {
            b.startObject((String)entry.getKey());
            b.startArray("shards");
            for (RecoveryState recoveryState : (List)entry.getValue()) {
                b.startObject();
                recoveryState.toXContent(b, p);
                b.endObject();
            }
            b.endArray();
            b.endObject();
            return b;
        }).iterator(), Iterators.single((b, p) -> b.endObject()));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMapOfLists(this.shardRecoveryStates, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

