/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.query.QueryBuilder;

public class IndicesAliasesRequestBuilder
extends AcknowledgedRequestBuilder<IndicesAliasesRequest, AcknowledgedResponse, IndicesAliasesRequestBuilder> {
    public IndicesAliasesRequestBuilder(ElasticsearchClient client, IndicesAliasesAction action) {
        super(client, action, new IndicesAliasesRequest());
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index).alias(alias));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, String filter) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index).alias(alias).filter(filter));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, String filter) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias).filter(filter));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, Map<String, Object> filter) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias).filter(filter));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, Map<String, Object> filter) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index).alias(alias).filter(filter));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, QueryBuilder filterBuilder) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias).filter(filterBuilder));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, QueryBuilder filterBuilder) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index).alias(alias).filter(filterBuilder));
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, boolean writeIndex) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index).alias(alias).writeIndex(writeIndex));
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String index, String alias) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.remove().index(index).alias(alias));
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String[] indices, String ... aliases) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(indices).aliases(aliases));
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String index, String[] aliases) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.remove().index(index).aliases(aliases));
        return this;
    }

    public IndicesAliasesRequestBuilder removeIndex(String index) {
        ((IndicesAliasesRequest)this.request).addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index(index));
        return this;
    }

    public IndicesAliasesRequestBuilder addAliasAction(IndicesAliasesRequest.AliasActions action) {
        ((IndicesAliasesRequest)this.request).addAliasAction(action);
        return this;
    }
}

