/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.cancel;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.TransportService;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    @Inject
    public TransportCancelTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/tasks/cancel", clusterService, transportService, actionFilters, CancelTasksRequest::new, CancelTasksResponse::new, TaskInfo::from, "generic");
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected List<CancellableTask> processTasks(CancelTasksRequest request) {
        if (request.getTargetTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTargetTaskId().getId());
            if (task != null) {
                if (request.match(task)) {
                    return List.of(task);
                }
                throw new IllegalArgumentException("task [" + request.getTargetTaskId() + "] doesn't support this operation");
            }
            if (this.taskManager.getTask(request.getTargetTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + request.getTargetTaskId() + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] is not found", request.getTargetTaskId());
        }
        ArrayList<CancellableTask> tasks = new ArrayList<CancellableTask>();
        for (CancellableTask task : this.taskManager.getCancellableTasks().values()) {
            if (!request.match(task)) continue;
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    protected void taskOperation(CancellableTask actionTask, CancelTasksRequest request, CancellableTask cancellableTask, ActionListener<TaskInfo> listener) {
        String nodeId = this.clusterService.localNode().getId();
        this.taskManager.cancelTaskAndDescendants(cancellableTask, request.getReason(), request.waitForCompletion(), listener.map(r -> cancellableTask.taskInfo(nodeId, false)));
    }
}

