/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.nodes.NodesOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;

public class NodesStatsRequestBuilder
extends NodesOperationRequestBuilder<NodesStatsRequest, NodesStatsResponse, NodesStatsRequestBuilder> {
    public NodesStatsRequestBuilder(ElasticsearchClient client, NodesStatsAction action) {
        super(client, action, new NodesStatsRequest());
    }

    public NodesStatsRequestBuilder all() {
        ((NodesStatsRequest)this.request).all();
        return this;
    }

    public NodesStatsRequestBuilder clear() {
        ((NodesStatsRequest)this.request).clear();
        return this;
    }

    public NodesStatsRequestBuilder setIndices(boolean indices) {
        ((NodesStatsRequest)this.request).indices(indices);
        return this;
    }

    public NodesStatsRequestBuilder setBreaker(boolean breaker) {
        this.addOrRemoveMetric(breaker, NodesStatsRequest.Metric.BREAKER);
        return this;
    }

    public NodesStatsRequestBuilder setScript(boolean script) {
        this.addOrRemoveMetric(script, NodesStatsRequest.Metric.SCRIPT);
        return this;
    }

    public NodesStatsRequestBuilder setIndices(CommonStatsFlags indices) {
        ((NodesStatsRequest)this.request).indices(indices);
        return this;
    }

    public NodesStatsRequestBuilder setOs(boolean os) {
        this.addOrRemoveMetric(os, NodesStatsRequest.Metric.OS);
        return this;
    }

    public NodesStatsRequestBuilder setProcess(boolean process) {
        this.addOrRemoveMetric(process, NodesStatsRequest.Metric.PROCESS);
        return this;
    }

    public NodesStatsRequestBuilder setJvm(boolean jvm) {
        this.addOrRemoveMetric(jvm, NodesStatsRequest.Metric.JVM);
        return this;
    }

    public NodesStatsRequestBuilder setThreadPool(boolean threadPool) {
        this.addOrRemoveMetric(threadPool, NodesStatsRequest.Metric.THREAD_POOL);
        return this;
    }

    public NodesStatsRequestBuilder setFs(boolean fs) {
        this.addOrRemoveMetric(fs, NodesStatsRequest.Metric.FS);
        return this;
    }

    public NodesStatsRequestBuilder setTransport(boolean transport) {
        this.addOrRemoveMetric(transport, NodesStatsRequest.Metric.TRANSPORT);
        return this;
    }

    public NodesStatsRequestBuilder setHttp(boolean http) {
        this.addOrRemoveMetric(http, NodesStatsRequest.Metric.HTTP);
        return this;
    }

    public NodesStatsRequestBuilder setDiscovery(boolean discovery) {
        this.addOrRemoveMetric(discovery, NodesStatsRequest.Metric.DISCOVERY);
        return this;
    }

    public NodesStatsRequestBuilder setIngest(boolean ingest) {
        this.addOrRemoveMetric(ingest, NodesStatsRequest.Metric.INGEST);
        return this;
    }

    public NodesStatsRequestBuilder setAdaptiveSelection(boolean adaptiveSelection) {
        this.addOrRemoveMetric(adaptiveSelection, NodesStatsRequest.Metric.ADAPTIVE_SELECTION);
        return this;
    }

    public NodesStatsRequestBuilder setScriptCache(boolean scriptCache) {
        this.addOrRemoveMetric(scriptCache, NodesStatsRequest.Metric.SCRIPT_CACHE);
        return this;
    }

    public NodesStatsRequestBuilder setIndexingPressure(boolean indexingPressure) {
        this.addOrRemoveMetric(indexingPressure, NodesStatsRequest.Metric.INDEXING_PRESSURE);
        return this;
    }

    public NodesStatsRequestBuilder setRepositoryStats(boolean repositoryStats) {
        this.addOrRemoveMetric(repositoryStats, NodesStatsRequest.Metric.REPOSITORIES);
        return this;
    }

    private void addOrRemoveMetric(boolean includeMetric, NodesStatsRequest.Metric metric) {
        if (includeMetric) {
            ((NodesStatsRequest)this.request).addMetric(metric.metricName());
        } else {
            ((NodesStatsRequest)this.request).removeMetric(metric.metricName());
        }
    }
}

