/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesReloadSecureSettingsAction
extends TransportNodesAction<NodesReloadSecureSettingsRequest, NodesReloadSecureSettingsResponse, NodesReloadSecureSettingsRequest.NodeRequest, NodesReloadSecureSettingsResponse.NodeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportNodesReloadSecureSettingsAction.class);
    private final Environment environment;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodesReloadSecureSettingsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Environment environment, PluginsService pluginService) {
        super("cluster:admin/nodes/reload_secure_settings", threadPool, clusterService, transportService, actionFilters, NodesReloadSecureSettingsRequest::new, NodesReloadSecureSettingsRequest.NodeRequest::new, "generic");
        this.environment = environment;
        this.pluginsService = pluginService;
    }

    @Override
    protected NodesReloadSecureSettingsResponse newResponse(NodesReloadSecureSettingsRequest request, List<NodesReloadSecureSettingsResponse.NodeResponse> responses, List<FailedNodeException> failures) {
        return new NodesReloadSecureSettingsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodesReloadSecureSettingsRequest.NodeRequest newNodeRequest(NodesReloadSecureSettingsRequest request) {
        return request.newNodeRequest();
    }

    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodesReloadSecureSettingsResponse.NodeResponse(in);
    }

    @Override
    protected void doExecute(Task task, NodesReloadSecureSettingsRequest request, ActionListener<NodesReloadSecureSettingsResponse> listener) {
        if (request.hasPassword() && !this.isNodeLocal(request) && !this.isNodeTransportTLSEnabled()) {
            request.close();
            listener.onFailure(new ElasticsearchException("Secure settings cannot be updated cluster wide when TLS for the transport layer is not enabled. Enable TLS or use the API with a `_local` filter on each node.", new Object[0]));
        } else {
            super.doExecute(task, request, ActionListener.runBefore(listener, request::close));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse nodeOperation(NodesReloadSecureSettingsRequest.NodeRequest nodeReloadRequest, Task task) {
        try (NodesReloadSecureSettingsRequest request = nodeReloadRequest.request;){
            KeyStoreWrapper keystore;
            block15: {
                keystore = KeyStoreWrapper.load(this.environment.configFile());
                try {
                    if (keystore != null) break block15;
                    NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), new IllegalStateException("Keystore is missing"));
                    if (keystore != null) {
                        keystore.close();
                    }
                    return nodeResponse;
                }
                catch (Throwable throwable) {
                    try {
                        if (keystore != null) {
                            try {
                                keystore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), e);
                        return nodeResponse;
                    }
                }
            }
            keystore.decrypt(request.hasPassword() ? request.getSecureSettingsPassword().getChars() : new char[]{});
            Settings settingsWithKeystore = Settings.builder().put(this.environment.settings(), false).setSecureSettings(keystore).build();
            ArrayList exceptions = new ArrayList();
            this.pluginsService.filterPlugins(ReloadablePlugin.class).forEach(p -> {
                try {
                    p.reload(settingsWithKeystore);
                }
                catch (Exception e) {
                    logger.warn(() -> "Reload failed for plugin [" + p.getClass().getSimpleName() + "]", (Throwable)e);
                    exceptions.add(e);
                }
            });
            ExceptionsHelper.rethrowAndSuppress(exceptions);
            NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), null);
            if (keystore != null) {
                keystore.close();
            }
            return nodeResponse;
        }
    }

    private boolean isNodeTransportTLSEnabled() {
        return this.transportService.isTransportSecure();
    }

    private boolean isNodeLocal(NodesReloadSecureSettingsRequest request) {
        DiscoveryNode[] nodes;
        if (null == request.concreteNodes()) {
            this.resolveRequest(request, this.clusterService.state());
            assert (request.concreteNodes() != null);
        }
        return (nodes = request.concreteNodes()).length == 1 && nodes[0].getId().equals(this.clusterService.localNode().getId());
    }
}

