/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.coordination;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.coordination.ClusterFormationFailureHelper;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class ClusterFormationInfoAction
extends ActionType<Response> {
    public static final ClusterFormationInfoAction INSTANCE = new ClusterFormationInfoAction();
    public static final String NAME = "internal:cluster/formation/info";

    private ClusterFormationInfoAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Coordinator coordinator;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, Coordinator coordinator) {
            super(ClusterFormationInfoAction.NAME, transportService, actionFilters, Request::new, "cluster_coordination");
            this.coordinator = coordinator;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            listener.onResponse(new Response(this.coordinator.getClusterFormationState()));
        }
    }

    public static class Response
    extends ActionResponse {
        private final ClusterFormationFailureHelper.ClusterFormationState clusterFormationState;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.clusterFormationState = new ClusterFormationFailureHelper.ClusterFormationState(in);
        }

        public Response(ClusterFormationFailureHelper.ClusterFormationState clusterFormationState) {
            this.clusterFormationState = clusterFormationState;
        }

        public ClusterFormationFailureHelper.ClusterFormationState getClusterFormationState() {
            return this.clusterFormationState;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterFormationState.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.clusterFormationState.equals(response.clusterFormationState);
        }

        public int hashCode() {
            return Objects.hash(this.clusterFormationState);
        }
    }

    public static class Request
    extends ActionRequest {
        public Request() {
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }
}

