/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.allocation.DesiredBalanceRequest;
import org.elasticsearch.action.admin.cluster.allocation.DesiredBalanceResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.ClusterBalanceStats;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDesiredBalanceAction
extends TransportMasterNodeReadAction<DesiredBalanceRequest, DesiredBalanceResponse> {
    @Nullable
    private final DesiredBalanceShardsAllocator desiredBalanceShardsAllocator;
    private final ClusterInfoService clusterInfoService;
    private final WriteLoadForecaster writeLoadForecaster;

    @Inject
    public TransportGetDesiredBalanceAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, WriteLoadForecaster writeLoadForecaster) {
        super("cluster:admin/desired_balance/get", transportService, clusterService, threadPool, actionFilters, DesiredBalanceRequest::new, indexNameExpressionResolver, DesiredBalanceResponse::from, "management");
        DesiredBalanceShardsAllocator allocator;
        this.desiredBalanceShardsAllocator = shardsAllocator instanceof DesiredBalanceShardsAllocator ? (allocator = (DesiredBalanceShardsAllocator)shardsAllocator) : null;
        this.clusterInfoService = clusterInfoService;
        this.writeLoadForecaster = writeLoadForecaster;
    }

    @Override
    protected void masterOperation(Task task, DesiredBalanceRequest request, ClusterState state, ActionListener<DesiredBalanceResponse> listener) throws Exception {
        if (this.desiredBalanceShardsAllocator == null) {
            listener.onFailure(new ResourceNotFoundException("Desired balance allocator is not in use, no desired balance found", new Object[0]));
            return;
        }
        DesiredBalance latestDesiredBalance = this.desiredBalanceShardsAllocator.getDesiredBalance();
        if (latestDesiredBalance == null) {
            listener.onFailure(new ResourceNotFoundException("Desired balance is not computed yet", new Object[0]));
            return;
        }
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        listener.onResponse(new DesiredBalanceResponse(this.desiredBalanceShardsAllocator.getStats(), ClusterBalanceStats.createFrom(state, clusterInfo, this.writeLoadForecaster), this.createRoutingTable(state, latestDesiredBalance), clusterInfo));
    }

    private Map<String, Map<Integer, DesiredBalanceResponse.DesiredShards>> createRoutingTable(ClusterState state, DesiredBalance latestDesiredBalance) {
        HashMap<String, Map<Integer, DesiredBalanceResponse.DesiredShards>> routingTable = new HashMap<String, Map<Integer, DesiredBalanceResponse.DesiredShards>>();
        for (IndexRoutingTable indexRoutingTable : state.routingTable()) {
            HashMap<Integer, DesiredBalanceResponse.DesiredShards> indexDesiredShards = new HashMap<Integer, DesiredBalanceResponse.DesiredShards>();
            IndexMetadata indexMetadata = state.metadata().index(indexRoutingTable.getIndex());
            for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shardId);
                ShardAssignment shardAssignment = latestDesiredBalance.assignments().get(shardRoutingTable.shardId());
                ArrayList<DesiredBalanceResponse.ShardView> shardViews = new ArrayList<DesiredBalanceResponse.ShardView>();
                for (int idx = 0; idx < shardRoutingTable.size(); ++idx) {
                    ShardRouting shard = shardRoutingTable.shard(idx);
                    OptionalDouble forecastedWriteLoad = this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata);
                    OptionalLong forecastedShardSizeInBytes = indexMetadata.getForecastedShardSizeInBytes();
                    shardViews.add(new DesiredBalanceResponse.ShardView(shard.state(), shard.primary(), shard.currentNodeId(), TransportGetDesiredBalanceAction.isDesired(shard.currentNodeId(), shardAssignment), shard.relocatingNodeId(), shard.relocatingNodeId() != null ? Boolean.valueOf(TransportGetDesiredBalanceAction.isDesired(shard.relocatingNodeId(), shardAssignment)) : null, shard.shardId().id(), shard.getIndexName(), forecastedWriteLoad.isPresent() ? Double.valueOf(forecastedWriteLoad.getAsDouble()) : null, forecastedShardSizeInBytes.isPresent() ? Long.valueOf(forecastedShardSizeInBytes.getAsLong()) : null, indexMetadata.getTierPreference()));
                }
                indexDesiredShards.put(shardId, new DesiredBalanceResponse.DesiredShards(shardViews, shardAssignment == null ? DesiredBalanceResponse.ShardAssignmentView.EMPTY : new DesiredBalanceResponse.ShardAssignmentView(shardAssignment.nodeIds(), shardAssignment.total(), shardAssignment.unassigned(), shardAssignment.ignored())));
            }
            routingTable.put(indexRoutingTable.getIndex().getName(), indexDesiredShards);
        }
        return routingTable;
    }

    private static boolean isDesired(@Nullable String nodeId, @Nullable ShardAssignment assignment) {
        return nodeId != null && assignment != null && assignment.nodeIds().contains(nodeId);
    }

    @Override
    protected ClusterBlockException checkBlock(DesiredBalanceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

